import os
import re
import argparse

import numpy as np

from util import create_co_matrix, threshold_cooccur, sppmi


def build_sppmi_matrix(cor, word2id, vocab_size, window_size, shift):
    C = create_co_matrix(cor, word2id, vocab_size, window_size)
    
    # threshold by min_count
    threshold = 0
    if threshold:
        C = threshold_cooccur(C, threshold=threshold)

    print('Computing sppmi matrix...')
    
    has_abs_dis = False
    has_cds = False
    # use smoothing or not in computing sppmi
    W = sppmi(C, shift, has_abs_dis=has_abs_dis, has_cds=has_cds)

    return W